/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Function;
import com.sun.jna.FunctionMapper;
import com.sun.jna.FunctionResultContext$CallbackResultContext;
import com.sun.jna.Klass$JNIEnv;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.StructureWriteContext$MethodResultContext;
import com.sun.jna.SymbolProvider;
import com.sun.jna.Union$CallbackResultContext;
import com.sun.jna.Union$PointerType;
import com.sun.jna.internal.Cleaner;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import melotr.MCDAEventListener;
import melotr.MCDARichHelper;

public class NativeLibrary
implements Closeable {
    final Map<String, ?> options;
    private static final Logger LOG = Logger.getLogger(NativeLibrary.class.getName());
    private final String libraryPath;
    private static final SymbolProvider NATIVE_SYMBOL_PROVIDER;
    private final Map<String, Function> functions = new HashMap<String, Function>();
    private long handle;
    private Cleaner.Cleanable cleanable;
    private final String libraryName;
    private static final int DEFAULT_OPEN_OPTIONS = -1;
    private static final Map<String, List<String>> searchPaths;
    private static final Level DEBUG_LOAD_LEVEL;
    private static final LinkedHashSet<String> librarySearchPath;
    private static Method addSuppressedMethod;
    private String encoding;
    private static final Map<String, Reference<NativeLibrary>> libraries;
    private final SymbolProvider symbolProvider;
    final int callFlags;

    static String[] matchFramework(String libraryName) {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        File framework = new File(libraryName);
        if (framework.isAbsolute()) {
            if (libraryName.contains(MCDAEventListener.l(Klass$JNIEnv.n("\uf3f7\u9d45\u0fe2\u9684\uc8c0\u01e7\u7bbd\uf446\ueece\u1296")))) {
                if (framework.exists()) {
                    return new String[]{framework.getAbsolutePath()};
                }
                paths.add(framework.getAbsolutePath());
            } else {
                if ((framework = new File(new File(framework.getParentFile(), framework.getName() + MCDARichHelper.l(Klass$JNIEnv.n("\uf3df\u9d10\u0fca\u96d1\uc8e8\u01b2\u7b95\uf413\ueee6\u12c3"))), framework.getName())).exists()) {
                    return new String[]{framework.getAbsolutePath()};
                }
                paths.add(framework.getAbsolutePath());
            }
        } else {
            String[] PREFIXES = new String[]{System.getProperty(MCDAEventListener.l(Klass$JNIEnv.n("\uf3a2\u9d5e\u0ffb\u9699\uc88d\u01e4\u7bab\uf44a\ueed7"))), "", MCDARichHelper.l(Klass$JNIEnv.n("\uf3ad\u9d56\u0fb2\u96b0\uc882\u01c1\u7bfc"))};
            String suffix = !libraryName.contains(MCDAEventListener.l(Klass$JNIEnv.n("\uf3f7\u9d45\u0fe2\u9684\uc8c0\u01e7\u7bbd\uf446\ueece\u1296"))) ? libraryName + MCDARichHelper.l(Klass$JNIEnv.n("\uf3ac\u9d63\u0fb9\u96a2\uc89b\u01c1\u7be6\uf460\uee95\u12b0\u8b68")) + libraryName : libraryName;
            for (String prefix : PREFIXES) {
                framework = new File(prefix + MCDAEventListener.l(Klass$JNIEnv.n("\uf3f6\u9d6f\u0ff9\u9687\uc8df\u01e3\u7bb8\uf450\uee93\u12bb\u8b6e\u3afd\u465b\u58c3\u36a1\u68f9\uad23\u7b32\udfc4\u69e9")) + suffix);
                if (framework.exists()) {
                    return new String[]{framework.getAbsolutePath()};
                }
                paths.add(framework.getAbsolutePath());
            }
        }
        return paths.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final NativeLibrary getInstance(String libraryName, Map<String, ?> libraryOptions) {
        HashMap options = new HashMap(libraryOptions);
        if (options.get(Union$CallbackResultContext.U("\u4fb1\ud566\u25e6\ua180\u976d\ue63e\u614b\u1ea1\uc104\u8320\u1859\uda1a\u9446\u0f85\u2fcd\u4d41\u84b6\u4894")) == null) {
            options.put(Union$CallbackResultContext.U("\u4fb1\ud566\u25e6\ua180\u976d\ue63e\u614b\u1ea1\uc104\u8320\u1859\uda1a\u9446\u0f85\u2fcd\u4d41\u84b6\u4894"), 0);
        }
        if ((Platform.isLinux() || Platform.isFreeBSD() || Platform.isAIX()) && Platform.C_LIBRARY_NAME.equals(libraryName)) {
            libraryName = null;
        }
        Map<String, Reference<NativeLibrary>> map = libraries;
        synchronized (map) {
            NativeLibrary library;
            Reference<NativeLibrary> ref = libraries.get(libraryName + options);
            NativeLibrary nativeLibrary = library = ref != null ? ref.get() : null;
            if (library == null) {
                library = libraryName == null ? new NativeLibrary(MCDARichHelper.l(Union$CallbackResultContext.U("\u4f87\ud56d\u2591\ua199\u970e\ue62f\u6136\u1ee5\uc130")), null, Native.open(null, NativeLibrary.openFlags(options)), options) : NativeLibrary.loadLibrary(libraryName, options);
                ref = new WeakReference<NativeLibrary>(library);
                libraries.put(library.getName() + options, ref);
                File file = library.getFile();
                if (file != null) {
                    libraries.put(file.getAbsolutePath() + options, ref);
                    libraries.put(file.getName() + options, ref);
                }
            }
            return library;
        }
    }

    static String matchLibrary(final String libName, Collection<String> searchPath) {
        File lib = new File(libName);
        if (lib.isAbsolute()) {
            searchPath = Arrays.asList(lib.getParent());
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return (filename.startsWith(LastErrorException.l(Union$PointerType.H("\u7d91\u42a5\u4279")) + libName + MCDARichHelper.l(Union$PointerType.H("\u7dd1\u42b7\u4276"))) || filename.startsWith(libName + LastErrorException.l(Union$PointerType.H("\u7dd3\u42bf\u4274"))) && libName.startsWith(MCDARichHelper.l(Union$PointerType.H("\u7d93\u42ad\u427b")))) && NativeLibrary.isVersionedName(filename);
            }
        };
        LinkedList<File> matches = new LinkedList<File>();
        for (String path : searchPath) {
            File[] files = new File(path).listFiles(filter);
            if (files == null || files.length <= 0) continue;
            matches.addAll(Arrays.asList(files));
        }
        double bestVersion = -1.0;
        String bestMatch = null;
        for (File f : matches) {
            String path = f.getAbsolutePath();
            String ver = path.substring(path.lastIndexOf(MCDAEventListener.l(StructureWriteContext$MethodResultContext.u("\udfe7\u6c41\u3194\ubc2c"))) + 4);
            double version = NativeLibrary.parseVersion(ver);
            if (!(version > bestVersion)) continue;
            bestVersion = version;
            bestMatch = path;
        }
        return bestMatch;
    }

    public String toString() {
        return MCDARichHelper.l(Union$PointerType.H("\u6e77\ud0f4\u8a43\u263f\u2755\ud859\ufa2a\u89d6\u904a\u5c51\u29bf\uff28\uf59f\ub05c\u0a69\u70c0")) + this.libraryPath + MCDAEventListener.l(Union$PointerType.H("\u6e5f")) + this.handle + MCDARichHelper.l(Union$PointerType.H("\u6e74"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ NativeLibrary(String libraryName, String libraryPath, long handle, Map<String, ?> options) {
        int callingConvention;
        this.libraryName = this.getLibraryName(libraryName);
        this.libraryPath = libraryPath;
        this.handle = handle;
        this.cleanable = Cleaner.getCleaner().register(this, new NativeLibraryDisposer(handle));
        Object option = options.get(Union$CallbackResultContext.U("\u1715\u88e3\u9293\u7d4e\u4c79\uc4c2\u7bde\uea03\u7f62\u992a\u70ce\u92c7\ua6f2\ua331\u3a15\u5186\ucecc\u59f2"));
        this.callFlags = callingConvention = option instanceof Number ? ((Number)option).intValue() : 0;
        this.options = options;
        this.encoding = (String)options.get(Union$CallbackResultContext.U("\u1705\u88f6\u928d\u7d4b\u4c7e\uc4cb\u7b94\uea4b\u7f6f\u9926\u70cf\u92d5\ua6fe\ua331\u3a06"));
        SymbolProvider optionSymbolProvider = (SymbolProvider)options.get(Union$CallbackResultContext.U("\u1705\u88fb\u9292\u7d40\u4c7f\uc4c0\u7b94\uea5e\u7f73\u992a\u70d6\u92d8\ua6f3\ua33a\u3a13"));
        this.symbolProvider = optionSymbolProvider == null ? NATIVE_SYMBOL_PROVIDER : optionSymbolProvider;
        if (this.encoding == null) {
            this.encoding = Native.getDefaultStringEncoding();
        }
        if (Platform.isWindows() && MCDAEventListener.l(Union$CallbackResultContext.U("\u172f\u88db\u92bf\u7d70\u4c47\uc4fc\u7bb8\uea20")).equals(this.libraryName.toLowerCase())) {
            Map<String, Function> map = this.functions;
            synchronized (map) {
                Function f = new Function(this, MCDARichHelper.l(Union$CallbackResultContext.U("\u172b\u888e\u9291\u7d07\u4c6b\uc4b6\u7bd7\uea02\u7f69\u995e\u70d5\u92aa")), 63, this.encoding){

                    @Override
                    Object invoke(Method invokingMethod, Class<?>[] paramTypes, Class<?> returnType, Object[] inArgs, Map<String, ?> options) {
                        return Native.getLastError();
                    }

                    @Override
                    Object invoke(Object[] args, Class<?> returnType, boolean b, int fixedArgs) {
                        return Native.getLastError();
                    }
                };
                this.functions.put(NativeLibrary.functionKey(MCDAEventListener.l(Union$CallbackResultContext.U("\u1703\u88db\u92b9\u7d52\u4c43\uc4e3\u7bff\uea57\u7f41\u990b\u70fd\u92ff")), this.callFlags, this.encoding), f);
            }
        }
    }

    public Map<String, ?> getOptions() {
        return this.options;
    }

    public Pointer getGlobalVariableAddress(String symbolName) {
        try {
            return new Pointer(this.getSymbolAddress(symbolName));
        }
        catch (UnsatisfiedLinkError e) {
            throw new UnsatisfiedLinkError(MCDARichHelper.l(Union$PointerType.H("\u12b3\u9308\u7a4a\u4abd\u85d0\ua8f4\ubb75\ua416\u8182\uc702\ucc53\uf715\u6af0\u9760\u16e8\ua258\u761a\u6fd3")) + symbolName + MCDAEventListener.l(Union$PointerType.H("\u12f7\u931b\u7a3e")) + e.getMessage());
        }
    }

    static double parseVersion(String ver) {
        double v = 0.0;
        double divisor = 1.0;
        int dot = ver.indexOf(MCDARichHelper.l(StructureWriteContext$MethodResultContext.u("\u29a1")));
        while (ver != null) {
            String num;
            if (dot != -1) {
                num = ver.substring(0, dot);
                ver = ver.substring(dot + 1);
                dot = ver.indexOf(MCDAEventListener.l(StructureWriteContext$MethodResultContext.u("\u29f4")));
            } else {
                num = ver;
                ver = null;
            }
            try {
                v += (double)Integer.parseInt(num) / divisor;
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
            divisor *= 100.0;
        }
        return v;
    }

    private static /* synthetic */ int openFlags(Map<String, ?> options) {
        Object opt = options.get(FunctionResultContext$CallbackResultContext.p("\ub3c4\u467c\uecb4\uf8f1\ucea0\ue200\u2830\u2fbd\ub521\u1853"));
        if (opt instanceof Number) {
            return ((Number)opt).intValue();
        }
        return -1;
    }

    public static final NativeLibrary getInstance(String libraryName) {
        return NativeLibrary.getInstance(libraryName, Collections.emptyMap());
    }

    private static /* synthetic */ String findLibraryPath(String libName, Collection<String> searchPath) {
        if (new File(libName).isAbsolute()) {
            return libName;
        }
        String name = NativeLibrary.mapSharedLibraryName(libName);
        for (String path : searchPath) {
            File file = new File(path, name);
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            if (!Platform.isMac() || !name.endsWith(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\u9820\u0793\u11f4\u7d1d\u6916\u47ae"))) || !(file = new File(path, name.substring(0, name.lastIndexOf(MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\u9808\u07c6\u11dc\u7d48\u693e\u47fb")))) + MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\u9853\u07ee\u1190\u7d6b\u6960\u47d6\ue506")))).exists()) continue;
            return file.getAbsolutePath();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HashSet<String> keys = new HashSet<String>();
        Object object = libraries;
        synchronized (object) {
            for (Map.Entry<String, Reference<NativeLibrary>> e : libraries.entrySet()) {
                Reference<NativeLibrary> ref = e.getValue();
                if (ref.get() != this) continue;
                keys.add(e.getKey());
            }
            for (String k : keys) {
                libraries.remove(k);
            }
        }
        object = this;
        synchronized (object) {
            if (this.handle != 0L) {
                this.cleanable.clean();
                this.handle = 0L;
            }
        }
    }

    public static final synchronized NativeLibrary getProcess(Map<String, ?> options) {
        return NativeLibrary.getInstance(null, options);
    }

    private /* synthetic */ String getLibraryName(String libraryName) {
        String suffix;
        int suffixStart;
        String simplified = libraryName;
        String BASE = MCDAEventListener.l(Union$PointerType.H("\uef41\u0717\u533f"));
        String template = NativeLibrary.mapSharedLibraryName(MCDARichHelper.l(Union$PointerType.H("\uef14\u073f\u536a")));
        int prefixEnd = template.indexOf(MCDAEventListener.l(Union$PointerType.H("\uef41\u0717\u533f")));
        if (prefixEnd > 0 && simplified.startsWith(template.substring(0, prefixEnd))) {
            simplified = simplified.substring(prefixEnd);
        }
        if ((suffixStart = simplified.indexOf(suffix = template.substring(prefixEnd + MCDARichHelper.l(Union$PointerType.H("\uef14\u073f\u536a")).length()))) != -1) {
            simplified = simplified.substring(0, suffixStart);
        }
        return simplified;
    }

    public File getFile() {
        if (this.libraryPath == null) {
            return null;
        }
        return new File(this.libraryPath);
    }

    private static /* synthetic */ boolean isVersionedName(String name) {
        int so;
        if (name.startsWith(MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\ue7fe\ud537\uc91d"))) && (so = name.lastIndexOf(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\ue79a\ud576\uc936\uc8a7")))) != -1 && so + 4 < name.length()) {
            for (int i = so + 4; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (Character.isDigit(ch) || ch == '.') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final synchronized NativeLibrary getProcess() {
        return NativeLibrary.getInstance(null);
    }

    private static /* synthetic */ void addSuppressedReflected(Throwable target, Throwable suppressed) {
        if (addSuppressedMethod == null) {
            return;
        }
        try {
            addSuppressedMethod.invoke((Object)target, suppressed);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(MCDAEventListener.l(Klass$JNIEnv.n("\ubb6f\u4dae\u828d\u02ef\ueddf\uf224\uac7b\u5a6b\ud986\uf2ab\uc11d\u75ce\uc86e\u4d1e\ubddf\ud325\u1259\u3a23\u613e\u02f3\u7ce4\ud954\ud23e\u5202\u17ea\u0729\u09d6\ue2f1\ubb5f\uc60a\u3675\ub22e\u09a1\u6cc8")), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(MCDARichHelper.l(Klass$JNIEnv.n("\ubb47\u4dfb\u82a5\u02ba\uedf7\uf271\uac53\u5a3e\ud9ae\uf2fe\uc135\u759b\uc846\u4d4b\ubdf7\ud370\u1271\u3a76\u6116\u02a6\u7ccc\ud901\ud216\u5257\u17c2\u077c\u09fe\ue2a4\ubb77\uc65f\u365d\ub27b\u0989\u6c9d")), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(MCDAEventListener.l(Klass$JNIEnv.n("\ubb6f\u4dae\u828d\u02ef\ueddf\uf224\uac7b\u5a6b\ud986\uf2ab\uc11d\u75ce\uc86e\u4d1e\ubddf\ud325\u1259\u3a23\u613e\u02f3\u7ce4\ud954\ud23e\u5202\u17ea\u0729\u09d6\ue2f1\ubb5f\uc60a\u3675\ub22e\u09a1\u6cc8")), ex);
        }
    }

    @Deprecated
    public void dispose() {
        this.close();
    }

    public static final NativeLibrary getInstance(String libraryName, ClassLoader classLoader) {
        return NativeLibrary.getInstance(libraryName, Collections.singletonMap(FunctionResultContext$CallbackResultContext.p("\ud9b8\u1efd\u7d85\ue5c8\ua7de\ua114\uf69f\u6bf2\ua27d\u0f23\ue9e2"), classLoader));
    }

    public static final void addSearchPath(String libraryName, String path) {
        List<String> customPaths = searchPaths.get(libraryName);
        if (customPaths == null) {
            customPaths = Collections.synchronizedList(new ArrayList());
            searchPaths.put(libraryName, customPaths);
        }
        customPaths.add(path);
    }

    public Function getFunction(String functionName, int callFlags) {
        return this.getFunction(functionName, callFlags, this.encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeAll() {
        LinkedHashSet<Reference<NativeLibrary>> values;
        Map<String, Reference<NativeLibrary>> map = libraries;
        synchronized (map) {
            values = new LinkedHashSet<Reference<NativeLibrary>>(libraries.values());
        }
        for (Reference reference : values) {
            NativeLibrary lib = (NativeLibrary)reference.get();
            if (lib == null) continue;
            lib.close();
        }
    }

    Function getFunction(String name, Method method) {
        String prefix;
        FunctionMapper mapper = (FunctionMapper)this.options.get(Union$CallbackResultContext.U("\ud29a\udb56\u75fb\u1525\u2479\u9718\u0177\ub6fd\u7085\u7916\u5ccc\u7485\u5ac6\uf9c6\u6b9a"));
        if (mapper != null) {
            name = mapper.getFunctionName(this, method);
        }
        if (name.startsWith(prefix = System.getProperty(MCDARichHelper.l(Union$CallbackResultContext.U("\ud2ff\udb57\u759d\u1572\u2414\u9719\u011e\ub6ef\u70a8\u790d\u5ca1\u749d\u5af1\uf9c9\u6bf3\u7e71\ue75d\u83e4\u6b36")), MCDAEventListener.l(Union$CallbackResultContext.U("\ud2e4\udb35\u75f0\u153e\u2461\u9767\u0100"))))) {
            name = name.substring(prefix.length());
        }
        int flags = this.callFlags;
        Class<?>[] etypes = method.getExceptionTypes();
        for (int i = 0; i < etypes.length; ++i) {
            if (!LastErrorException.class.isAssignableFrom(etypes[i])) continue;
            flags |= 0x40;
        }
        return this.getFunction(name, flags);
    }

    static String mapSharedLibraryName(String libName) {
        if (Platform.isMac()) {
            if (libName.startsWith(MCDARichHelper.l(Union$CallbackResultContext.U("\u6869\u3494\ua3ea"))) && (libName.endsWith(MCDAEventListener.l(Union$CallbackResultContext.U("\u6870\u34bf\ua3aa\ue1f7\ue583\u9153"))) || libName.endsWith(MCDARichHelper.l(Union$CallbackResultContext.U("\u682b\u3497\ua3e6\ue1d4\ue5dd\u917e\u99a5"))))) {
                return libName;
            }
            String name = System.mapLibraryName(libName);
            if (name.endsWith(MCDAEventListener.l(Union$CallbackResultContext.U("\u687e\u34bf\ua3b3\ue1fc\ue588\u9156\u99f0")))) {
                return name.substring(0, name.lastIndexOf(MCDARichHelper.l(Union$CallbackResultContext.U("\u682b\u3497\ua3e6\ue1d4\ue5dd\u917e\u99a5")))) + MCDAEventListener.l(Union$CallbackResultContext.U("\u6870\u34bf\ua3aa\ue1f7\ue583\u9153"));
            }
            return name;
        }
        if (Platform.isLinux() || Platform.isFreeBSD() ? NativeLibrary.isVersionedName(libName) || libName.endsWith(MCDARichHelper.l(Union$CallbackResultContext.U("\u682b\u348e\ua3e7"))) : (Platform.isAIX() ? NativeLibrary.isVersionedName(libName) || libName.endsWith(MCDAEventListener.l(Union$CallbackResultContext.U("\u687e\u34a6\ua3b2"))) || libName.startsWith(MCDARichHelper.l(Union$CallbackResultContext.U("\u6869\u3494\ua3ea"))) || libName.endsWith(MCDAEventListener.l(Union$CallbackResultContext.U("\u6870\u34ba"))) : Platform.isWindows() && (libName.endsWith(MCDARichHelper.l(Union$CallbackResultContext.U("\u6858\u34ea\ua389\ue1b8"))) || libName.endsWith(MCDAEventListener.l(Union$CallbackResultContext.U("\u6870\u34bf\ua3bf\ue1f7"))) || libName.endsWith(MCDARichHelper.l(Union$CallbackResultContext.U("\u6858\u34e1\ua398\ue1b6")))))) {
            return libName;
        }
        String mappedName = System.mapLibraryName(libName);
        if (Platform.isAIX() && mappedName.endsWith(MCDAEventListener.l(Union$CallbackResultContext.U("\u687e\u34a6\ua3b2")))) {
            return mappedName.replaceAll(MCDARichHelper.l(Union$CallbackResultContext.U("\u6858\u34fd\ua394\ue1ea")), MCDAEventListener.l(Union$CallbackResultContext.U("\u6870\u34ba")));
        }
        return mappedName;
    }

    public String getName() {
        return this.libraryName;
    }

    private static /* synthetic */ String getMultiArchPath() {
        String cpu = Platform.ARCH;
        String kernel = Platform.iskFreeBSD() ? MCDARichHelper.l(Union$PointerType.H("\u6d8b\u411c\u21c9\u06f1\u7e04\u08b1\u422f\u63f6\udfe2")) : (Platform.isGNU() ? "" : MCDAEventListener.l(Union$PointerType.H("\u6dd0\u413d\u219d\u06cb\u7e4f\u088a")));
        String libc = MCDARichHelper.l(Union$PointerType.H("\u6df8\u4163\u21b2\u0685"));
        if (Platform.isIntel()) {
            cpu = Platform.is64Bit() ? MCDAEventListener.l(Union$PointerType.H("\u6d85\u4169\u21c2\u06fa\u7e0c\u08c6")) : MCDARichHelper.l(Union$PointerType.H("\u6dbc\u4137\u21e4\u06c6"));
        } else if (Platform.isPPC()) {
            cpu = Platform.is64Bit() ? MCDAEventListener.l(Union$PointerType.H("\u6d83\u4130\u218d\u06ce\u7e46\u088c\u427b\u639b\udfe7")) : MCDARichHelper.l(Union$PointerType.H("\u6dd6\u4118\u21d8\u06e6\u7e13\u08a4\u422e"));
        } else if (Platform.isARM()) {
            cpu = MCDAEventListener.l(Union$PointerType.H("\u6d92\u412d\u2197"));
            libc = MCDARichHelper.l(Union$PointerType.H("\u6df8\u4163\u21b2\u0685\u7e77\u08c6\u425c\u639f"));
        } else if (Platform.ARCH.equals(MCDAEventListener.l(Union$PointerType.H("\u6d90\u4138\u2184\u06d6\u7e0c\u08c6\u4273\u63cf")))) {
            libc = MCDARichHelper.l(Union$PointerType.H("\u6d8b\u4110\u21c1\u06f6\u7e00\u08b6\u4224\u63b3\udfb2"));
        }
        return cpu + kernel + libc;
    }

    static {
        DEBUG_LOAD_LEVEL = Native.DEBUG_LOAD ? Level.INFO : Level.FINE;
        NATIVE_SYMBOL_PROVIDER = new SymbolProvider(){

            @Override
            public long getSymbolAddress(long handle, String name, SymbolProvider parent) {
                return Native.findSymbol(handle, name);
            }
        };
        libraries = new HashMap<String, Reference<NativeLibrary>>();
        searchPaths = new ConcurrentHashMap<String, List<String>>();
        librarySearchPath = new LinkedHashSet();
        if (Native.POINTER_SIZE == 0) {
            throw new Error(MCDAEventListener.l(Klass$JNIEnv.n("\uee71\ud8f8\u3c18\u17a4\u47ac\uaa35\u7202\u7ac3\uc5db\u100d\u0532\ud139\u4ae2\u0611\ub4a4\uc25a\uefe2\u8061\uc094\u7cea\uc805\u0540\u4acc\u32f4\u493e\uf6d5\u70bd\u77a0\uce04\ue46a")));
        }
        addSuppressedMethod = null;
        try {
            addSuppressedMethod = Throwable.class.getMethod(MCDARichHelper.l(Klass$JNIEnv.n("\uee05\ud8db\u3c53\u17b8\u47f4\uaa06\u7209\u7afb\uc58c\u103a\u0568\ud11b\u4aaf")), Throwable.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException ex) {
            Logger.getLogger(NativeLibrary.class.getName()).log(Level.SEVERE, MCDAEventListener.l(Klass$JNIEnv.n("\uee77\ud8f6\u3c0b\u17af\u47b1\uaa3a\u720c\u7ad5\uc5d3\u1041\u0527\ud138\u4af7\u0612\ub4e3\uc25b\uefef\u8072\uc0c0\u7ce8\uc845\u0500\u4ad7\u32f7\u4935\uf6e4\u70af\u77a4\uce1f\ue472\ucc9d\u1821\u304e\ub757\u185a\u4bd4\udedf\u5257\u91a8\u45f4\u4d10\u231d\ue1f7")), ex);
        }
        String webstartPath = Native.getWebStartLibraryPath(MCDARichHelper.l(Klass$JNIEnv.n("\uee0e\ud8d1\u3c5e\u178f\u47e8\uaa05\u7209\u7ae8\uc59d\u102a\u0573")));
        if (webstartPath != null) {
            librarySearchPath.add(webstartPath);
        }
        if (System.getProperty(MCDAEventListener.l(Klass$JNIEnv.n("\uee5b\ud8f9\u3c03\u17ed\u47a4\uaa32\u724d\u7ad5\uc5da\u100e\u053c\ud13b\u4ab0\u060a\ub4e3\uc258\ueff1\u807a\uc0c8\u7cf4\uc84b\u0557\u4ad7\u32e7\u4939"))) == null && !Platform.isWindows()) {
            String platformPath = "";
            String sep = "";
            String archPath = "";
            if (Platform.isLinux() || Platform.isSolaris() || Platform.isFreeBSD() || Platform.iskFreeBSD()) {
                archPath = (Platform.isSolaris() ? MCDARichHelper.l(Klass$JNIEnv.n("\uee4b")) : "") + Native.POINTER_SIZE * 8;
            }
            String[] paths = new String[]{MCDAEventListener.l(Klass$JNIEnv.n("\uee10\ud8ec\u3c1f\u17bf\u47f5\uaa3c\u724b\u7acd")) + archPath, MCDARichHelper.l(Klass$JNIEnv.n("\uee38\ud8a0\u3c2d\u17fa")) + archPath, MCDAEventListener.l(Klass$JNIEnv.n("\uee10\ud8ec\u3c1f\u17bf\u47f5\uaa3c\u724b\u7acd")), MCDARichHelper.l(Klass$JNIEnv.n("\uee38\ud8a0\u3c2d\u17fa"))};
            if (Platform.isLinux() || Platform.iskFreeBSD() || Platform.isGNU()) {
                String multiArchPath = NativeLibrary.getMultiArchPath();
                paths = new String[]{MCDAEventListener.l(Klass$JNIEnv.n("\uee1e\ud8e2\u3c11\u17b1\u47fb\uaa32\u7245\u7ac3\uc593")) + multiArchPath, MCDARichHelper.l(Klass$JNIEnv.n("\uee4b\ud8d3\u3c5e\u1789\u47ae")) + multiArchPath, MCDAEventListener.l(Klass$JNIEnv.n("\uee10\ud8ec\u3c1f\u17bf\u47f5\uaa3c\u724b\u7acd")) + archPath, MCDARichHelper.l(Klass$JNIEnv.n("\uee38\ud8a0\u3c2d\u17fa")) + archPath, MCDAEventListener.l(Klass$JNIEnv.n("\uee10\ud8ec\u3c1f\u17bf\u47f5\uaa3c\u724b\u7acd")), MCDARichHelper.l(Klass$JNIEnv.n("\uee38\ud8a0\u3c2d\u17fa"))};
            }
            if (Platform.isLinux()) {
                ArrayList<String> ldPaths = NativeLibrary.getLinuxLdPaths();
                for (int i = paths.length - 1; 0 <= i; --i) {
                    int found = ldPaths.indexOf(paths[i]);
                    if (found != -1) {
                        ldPaths.remove(found);
                    }
                    ldPaths.add(0, paths[i]);
                }
                paths = ldPaths.toArray(new String[0]);
            }
            for (int i = 0; i < paths.length; ++i) {
                File dir = new File(paths[i]);
                if (!dir.exists() || !dir.isDirectory()) continue;
                platformPath = platformPath + sep + paths[i];
                sep = File.pathSeparator;
            }
            if (!"".equals(platformPath)) {
                System.setProperty(MCDAEventListener.l(Klass$JNIEnv.n("\uee5b\ud8f9\u3c03\u17ed\u47a4\uaa32\u724d\u7ad5\uc5da\u100e\u053c\ud13b\u4ab0\u060a\ub4e3\uc258\ueff1\u807a\uc0c8\u7cf4\uc84b\u0557\u4ad7\u32e7\u4939")), platformPath);
            }
        }
        librarySearchPath.addAll(NativeLibrary.initPaths(MCDARichHelper.l(Klass$JNIEnv.n("\uee0e\ud8d1\u3c56\u17c5\u47f1\uaa1a\u7218\u7afd\uc58f\u1026\u0569\ud113\u4ae5\u0622\ub4b6\uc270\uefa4\u8052\uc09d\u7cdc\uc81e\u057f\u4a82\u32cf\u496c"))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ ArrayList<String> getLinuxLdPaths() {
        ArrayList<String> ldPaths = new ArrayList<String>();
        Process process = null;
        BufferedReader reader = null;
        try {
            String buffer;
            process = Runtime.getRuntime().exec(MCDAEventListener.l(Union$PointerType.H("\u1878\u600e\u2399\u1dbe\u8926\u61dd\ud771\ua062\u2278\u8aee\ub5b1\ue252\u45f9\u1601\u7532\u7dc4\u180e")));
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((buffer = reader.readLine()) != null) {
                String path;
                int startPath = buffer.indexOf(MCDARichHelper.l(Union$PointerType.H("\u1851\u601b\u23e3\u1dac")));
                int endPath = buffer.lastIndexOf(47);
                if (startPath == -1 || endPath == -1 || startPath >= endPath || ldPaths.contains(path = buffer.substring(startPath + 4, endPath))) continue;
                ldPaths.add(path);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (process != null) {
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return ldPaths;
    }

    private static /* synthetic */ List<String> initPaths(String key) {
        String value = System.getProperty(key, "");
        if ("".equals(value)) {
            return Collections.emptyList();
        }
        StringTokenizer st = new StringTokenizer(value, File.pathSeparator);
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            if ("".equals(path)) continue;
            list.add(path);
        }
        return list;
    }

    private static /* synthetic */ String functionKey(String name, int flags, String encoding) {
        return name + MCDAEventListener.l(Klass$JNIEnv.n("\u3222")) + flags + MCDARichHelper.l(Klass$JNIEnv.n("\u3277")) + encoding;
    }

    public Function getFunction(String functionName) {
        return this.getFunction(functionName, this.callFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ NativeLibrary loadLibrary(String libraryName, Map<String, ?> options) {
        long handle;
        String libraryPath;
        block40: {
            String webstartPath;
            LOG.log(DEBUG_LOAD_LEVEL, MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\uaf86\u7ca6\u0f41\ue25c\uee72\u1a83\u5ef9\ue66a\u8d8b\u7f78\u67c3\u2d9b\u7a76\u1805\u0dbe\u907d\ucfdd\u8f61\ud443\u4cb7\uab00")) + libraryName + MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\uafb8")));
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            boolean isAbsolutePath = new File(libraryName).isAbsolute();
            LinkedHashSet<String> searchPath = new LinkedHashSet<String>();
            int openFlags = NativeLibrary.openFlags(options);
            List<String> customPaths = searchPaths.get(libraryName);
            if (customPaths != null) {
                List<String> list = customPaths;
                synchronized (list) {
                    searchPath.addAll(customPaths);
                }
            }
            if ((webstartPath = Native.getWebStartLibraryPath(libraryName)) != null) {
                LOG.log(DEBUG_LOAD_LEVEL, MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\uaf85\u7ca3\u0f44\ue250\uee7b\u1a84\u5eb0\ue633\u8d86\u7f7b\u679f\u2dc6\u7a60\u1803\u0da0\u9075\ucf92\u8f6d\ud455\u4ced\uab41\u254f")) + webstartPath);
                searchPath.add(webstartPath);
            }
            LOG.log(DEBUG_LOAD_LEVEL, MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\uafad\u7cf6\u0f6c\ue205\uee53\u1ad1\u5e98\ue661\u8daa\u7f38\u67ff\u2d93\u7a1c\u1851\u0d88\u903b\ucff7\u8f68\ud476\u4ca2\uab60\u2514\ufe27\u1bbe\u6820\ude9d\u3314\u7277\ue33d\u3d61\uef50\ua9c4\u990f\ub928\uac2b\uf1a8")) + System.getProperty(MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\uafae\u7ca9\u0f41\ue217\uee79\u1a8a\u5ef2\ue636\u8d82\u7f6b\u67c6\u2d9b\u7a64\u1803\u0da6\u9069"))));
            searchPath.addAll(NativeLibrary.initPaths(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\uaf86\u7cfc\u0f69\ue242\uee51\u1adf\u5eda\ue663\u8daa\u7f3e\u67ee\u2dce\u7a4c\u1856\u0d8e\u903c"))));
            libraryPath = NativeLibrary.findLibraryPath(libraryName, searchPath);
            handle = 0L;
            try {
                LOG.log(DEBUG_LOAD_LEVEL, MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\uaf9e\u7cbb\u0f57\ue25e\uee75\u1a8a\u5ebe")) + libraryPath);
                handle = Native.open(libraryPath, openFlags);
            }
            catch (UnsatisfiedLinkError e) {
                LOG.log(DEBUG_LOAD_LEVEL, MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\uafd3\u7c8e\u0f1a\ue27b\uee27\u1aab\u5eac\ue642\u8dde\u7f5e\u678d\u2dff\u7a2a\u1820\u0da9\u9050\ucf80\u8f4f\ud407\u4c9f\uab1f\u252c\ufe4b\u1bd7\u6850\udefb\u3363\u724c\ue317")) + e.getMessage());
                LOG.log(DEBUG_LOAD_LEVEL, MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\uaf8b\u7cad\u0f4a\ue25e\uee75\u1a8a\u5ebe\ue639\u8d94\u7f64\u67c5\u2dde\u7a77\u184c\u0dac\u906e\ucfc8\u8f7b\ud449\u4cad\uab07")) + librarySearchPath);
                exceptions.add(e);
                searchPath.addAll(librarySearchPath);
            }
            try {
                if (handle == 0L) {
                    libraryPath = NativeLibrary.findLibraryPath(libraryName, searchPath);
                    LOG.log(DEBUG_LOAD_LEVEL, MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\uafcb\u7c93\u0f02\ue276\uee20\u1aa2\u5eeb")) + libraryPath);
                    handle = Native.open(libraryPath, openFlags);
                    if (handle == 0L) {
                        throw new UnsatisfiedLinkError(MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\uaf82\u7ca6\u0f49\ue255\uee70\u1a87\u5eb0\ue630\u8d8c\u7f39\u67d3\u2dda\u7a75\u1806\u0df2\u906d\ucfdb\u8f7f\ud446\u4cf8\uab5b\u2516\ufe43\u1ba5")) + libraryName + MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\uafb8")));
                    }
                }
            }
            catch (UnsatisfiedLinkError ule) {
                block39: {
                    LOG.log(DEBUG_LOAD_LEVEL, MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\uaf86\u7ca6\u0f4f\ue253\uee72\u1a83\u5ef9\ue66a\u8d8b\u7f76\u67d8\u2dd7\u7a7f\u1808\u0dfc\u9078\ucfd5\u8f67\ud452\u4cb7\uab4a\u2504\ufe1e\u1bff\u6805\uded3\u3336\u7264\ue342")) + ule.getMessage());
                    exceptions.add(ule);
                    if (Platform.isAndroid()) {
                        try {
                            LOG.log(DEBUG_LOAD_LEVEL, MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\uafcf\u7c93\u0f1e\ue273\uee21\u1aa4\u5eaf\ue642\u8d90\u7f49\u678d\u2df2\u7a6f\u1817\u0df0\u9054\ucf9d\u8f5e\ud402\u4c91\uab1e\u2526\ufe59\u1bc0\u687d\udef5\u3364\u7204\ue356\u3d4e\uef2a\ua9ff\u9928")) + libraryName);
                            System.loadLibrary(libraryName);
                            handle = Native.open(libraryPath, openFlags);
                        }
                        catch (UnsatisfiedLinkError e2) {
                            LOG.log(DEBUG_LOAD_LEVEL, MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\uaf86\u7ca6\u0f4f\ue253\uee72\u1a83\u5ef9\ue66a\u8d8b\u7f76\u67d8\u2dd7\u7a7f\u1808\u0dfc\u9078\ucfd5\u8f67\ud452\u4cb7\uab4a\u2504\ufe1e\u1bff\u6805\uded3\u3336\u7264\ue342")) + e2.getMessage());
                            exceptions.add(e2);
                        }
                    } else if (Platform.isLinux() || Platform.isFreeBSD()) {
                        LOG.log(DEBUG_LOAD_LEVEL, MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\uafa0\u7cfd\u0f67\ue207\uee54\u1ad8\u5edf\ue631\u8dad\u7f23\u67e5\u2dc0\u7a4a\u1852\u0d88\u9027\ucff3\u8f27\ud472\u4cec\uab77\u255b\ufe39\u1bbe\u6823\ude81\u3301\u7276")));
                        libraryPath = NativeLibrary.matchLibrary(libraryName, searchPath);
                        if (libraryPath != null) {
                            LOG.log(DEBUG_LOAD_LEVEL, MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\uaf9e\u7cbb\u0f57\ue25e\uee75\u1a8a\u5ebe")) + libraryPath);
                            try {
                                handle = Native.open(libraryPath, openFlags);
                            }
                            catch (UnsatisfiedLinkError e2) {
                                LOG.log(DEBUG_LOAD_LEVEL, MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\uafd3\u7c8e\u0f1a\ue27b\uee27\u1aab\u5eac\ue642\u8dde\u7f5e\u678d\u2dff\u7a2a\u1820\u0da9\u9050\ucf80\u8f4f\ud407\u4c9f\uab1f\u252c\ufe4b\u1bd7\u6850\udefb\u3363\u724c\ue317")) + e2.getMessage());
                                exceptions.add(e2);
                            }
                        }
                    } else if (Platform.isMac() && !libraryName.endsWith(MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\uafea\u7ca3\u0f59\ue255\uee7c\u1a81")))) {
                        for (String frameworkName : NativeLibrary.matchFramework(libraryName)) {
                            try {
                                LOG.log(DEBUG_LOAD_LEVEL, MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\uafcb\u7c93\u0f02\ue276\uee20\u1aa2\u5eeb")) + frameworkName);
                                handle = Native.open(frameworkName, openFlags);
                                break;
                            }
                            catch (UnsatisfiedLinkError e2) {
                                LOG.log(DEBUG_LOAD_LEVEL, MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\uaf86\u7ca6\u0f4f\ue253\uee72\u1a83\u5ef9\ue66a\u8d8b\u7f76\u67d8\u2dd7\u7a7f\u1808\u0dfc\u9078\ucfd5\u8f67\ud452\u4cb7\uab4a\u2504\ufe1e\u1bff\u6805\uded3\u3336\u7264\ue342")) + e2.getMessage());
                                exceptions.add(e2);
                            }
                        }
                    } else if (Platform.isWindows() && !isAbsolutePath) {
                        LOG.log(DEBUG_LOAD_LEVEL, MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\uafd3\u7c8e\u0f14\ue274\uee27\u1aab\u5eac\ue642\u8dde\u7f50\u6796\u2db3\u7a23\u182d\u0deb\u900a\ucfc9\u8f4b\ud41d\u4cda\uab14\u2520\ufe40")));
                        libraryPath = NativeLibrary.findLibraryPath(MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\uafa6\u7ca0\u0f4c")) + libraryName, searchPath);
                        if (libraryPath != null) {
                            LOG.log(DEBUG_LOAD_LEVEL, MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\uafcb\u7c93\u0f02\ue276\uee20\u1aa2\u5eeb")) + libraryPath);
                            try {
                                handle = Native.open(libraryPath, openFlags);
                            }
                            catch (UnsatisfiedLinkError e2) {
                                LOG.log(DEBUG_LOAD_LEVEL, MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\uaf86\u7ca6\u0f4f\ue253\uee72\u1a83\u5ef9\ue66a\u8d8b\u7f76\u67d8\u2dd7\u7a7f\u1808\u0dfc\u9078\ucfd5\u8f67\ud452\u4cb7\uab4a\u2504\ufe1e\u1bff\u6805\uded3\u3336\u7264\ue342")) + e2.getMessage());
                                exceptions.add(e2);
                            }
                        }
                    }
                    if (handle == 0L) {
                        try {
                            File embedded = Native.extractFromResourcePath(libraryName, (ClassLoader)options.get(FunctionResultContext$CallbackResultContext.p("\uaf95\u7c97\u0f73\ue276\uee54\u1ab3\u5ecd\ue619\u8db5\u7f40\u67ff")));
                            if (embedded == null) break block39;
                            try {
                                handle = Native.open(embedded.getAbsolutePath(), openFlags);
                                libraryPath = embedded.getAbsolutePath();
                            }
                            finally {
                                if (Native.isUnpacked(embedded)) {
                                    Native.deleteLibrary(embedded);
                                }
                            }
                        }
                        catch (IOException e2) {
                            LOG.log(DEBUG_LOAD_LEVEL, MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\uafd3\u7c8e\u0f1a\ue27b\uee27\u1aab\u5eac\ue642\u8dde\u7f5e\u678d\u2dff\u7a2a\u1820\u0da9\u9050\ucf80\u8f4f\ud407\u4c9f\uab1f\u252c\ufe4b\u1bd7\u6850\udefb\u3363\u724c\ue317")) + e2.getMessage());
                            exceptions.add(e2);
                        }
                    }
                }
                if (handle != 0L) break block40;
                StringBuilder sb = new StringBuilder();
                sb.append(MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\uaf91\u7ca9\u0f41\ue25b\uee79\u1a86\u5eb0\ue630\u8d8c\u7f39\u67d3\u2dda\u7a75\u1806\u0df2\u906d\ucfdb\u8f7f\ud446\u4cf8\uab5b\u2516\ufe43\u1ba5")));
                sb.append(libraryName);
                sb.append(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\uafcb\u7ca8")));
                for (Throwable t : exceptions) {
                    sb.append(MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\uafc0")));
                    sb.append(t.getMessage());
                }
                UnsatisfiedLinkError res = new UnsatisfiedLinkError(sb.toString());
                for (Throwable t : exceptions) {
                    NativeLibrary.addSuppressedReflected(res, t);
                }
                throw res;
            }
        }
        LOG.log(DEBUG_LOAD_LEVEL, MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\uafd9\u7c8e\u0f0e\ue271\uee2a\u1ae5\u5ea7\ue60b\u8dda\u7f4d\u6785\u2de1\u7a36\u1864\u0dae")) + libraryName + MCDAEventListener.l(FunctionResultContext$CallbackResultContext.p("\uafed\u7ce9\u0f4f\ue243\uee3b")) + libraryPath);
        return new NativeLibrary(libraryName, libraryPath, handle, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function getFunction(String functionName, int callFlags, String encoding) {
        if (functionName == null) {
            throw new NullPointerException(MCDARichHelper.l(FunctionResultContext$CallbackResultContext.p("\ub06d\u9eed\uda8b\ufafd\uad61\u1c14\u5ac4\u6dfa\u17db\uaa25\uea2c\ufdbd\u037d\u935e\ue5c3\uc7b2\ue2e5\u55ba\u3e1f\u9852\u2381\u9f55\u60e4\udb58\u9133\u5f1e\uf0a4\u2e3e\u01ea")));
        }
        Map<String, Function> map = this.functions;
        synchronized (map) {
            String key = NativeLibrary.functionKey(functionName, callFlags, encoding);
            Function function = this.functions.get(key);
            if (function == null) {
                function = new Function(this, functionName, callFlags, encoding);
                this.functions.put(key, function);
            }
            return function;
        }
    }

    long getSymbolAddress(String name) {
        if (this.handle == 0L) {
            throw new UnsatisfiedLinkError(MCDAEventListener.l(Union$CallbackResultContext.U("\uc076\u062f\uac5d\u778a\uda79\u0c0f\ue6a6\u9a74\u4275\ueaa5\u57ec\u021e\uea91\u351c\u25ca\u325a\uc493\u85aa\ue508\u31da\uf8ac\u84fe\ucf3d\u4f27\u7e8e")));
        }
        return this.symbolProvider.getSymbolAddress(this.handle, name, NATIVE_SYMBOL_PROVIDER);
    }

    private static final class NativeLibraryDisposer
    implements Runnable {
        private long handle;

        public NativeLibraryDisposer(long handle) {
            this.handle = handle;
        }

        @Override
        public synchronized void run() {
            if (this.handle != 0L) {
                try {
                    Native.close(this.handle);
                }
                finally {
                    this.handle = 0L;
                }
            }
        }
    }
}

